<?php include 'config.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Redirecting To Secure Page</title>
  <meta http-equiv="refresh" content="<?php echo $countdown_time; ?>;url=<?php echo $redirect_url; ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">

  <style>
    body {
      margin: 0;
      padding: 0;
      font-family: 'Roboto', Arial, sans-serif;
      background: url("<?php echo $background_image; ?>") no-repeat center center fixed;
      background-size: cover;
    }

    .header-text {
      text-align: center;
      padding: 20px;
      font-size: 26px;
      font-weight: bold;
      color: #fff;
      text-shadow: 1px 1px 2px #000;
    }

    .banner-wrapper {
      text-align: center;
      margin: 10px 0;
    }

    .toggle-btn {
      background: #222;
      color: #fff;
      font-size: 12px;
      font-weight: bold;
      border: none;
      cursor: pointer;
      padding: 4px 10px;
      margin-bottom: 4px;
      border-radius: 4px;
      transition: 0.3s;
    }

    .toggle-btn:hover {
      background: #ff0000;
    }

    .banner-container {
      display: flex;
      justify-content: center;
    }

    .banner-container iframe {
      display: block;
      margin: 0 auto;
      border: none;
    }

    .hidden {
      display: none;
    }

    .container-box {
      display: flex;
      justify-content: center;
      gap: 20px;
      padding: 20px;
      flex-wrap: wrap;
    }

    .box {
      width: 400px;
      min-height: 360px;
      padding: 30px;
      border-radius: 8px;
      background: rgba(0,0,0,0.55);
      color: #fff;
      text-align: center;
      box-shadow: 0 4px 12px rgba(0,0,0,0.4);
      backdrop-filter: blur(4px);
    }

    .left-box h2 {
      color: #ffff00;
      font-size: 28px;
      margin-bottom: 10px;
    }

    .countdown {
      color: #00ff00;
      font-size: 28px;
      font-weight: bold;
      margin-bottom: 15px;
    }

    .redirect-text {
      font-size: 18px;
      line-height: 1.4;
      margin-bottom: 15px;
      color: #ffffff;
    }

    .redirect-text a {
      color: #00ff00;
      font-weight: bold;
      text-decoration: underline;
    }

    .left-box img {
      width: 60px;
      height: 60px;
    }

    .right-box h3 {
      color: #ffff00;
      font-size: 22px;
      margin-bottom: 10px;
    }

    .right-box .price {
      color: #00ff00;
      font-size: 28px;
      font-weight: bold;
      margin-bottom: 15px;
    }

    .right-box ul {
      list-style: none;
      padding: 0;
      margin: 0 auto;
      text-align: left;
      display: inline-block;
    }

    .right-box ul li {
      margin-bottom: 8px;
      font-size: 14px;
    }

    .right-box ul li::before {
      content: "✓ ";
      color: #00ff00;
      font-weight: bold;
    }

    @media (max-width: 860px) {
      .container-box {
        flex-direction: column;
        align-items: center;
      }
      .box {
        width: 90%;
      }
    }
  </style>
</head>
<body>
  <div class="header-text">STREAM 2025 MACY'S THANKSGIVING DAY PARADE</div>

  <!-- Banner atas -->
  <div class="banner-wrapper">
    <button class="toggle-btn" onclick="toggleBanner('bannerAtas', this)">Hide Ads</button>
    <div class="banner-container" id="bannerAtas">
      <iframe src="<?php echo $banner_top; ?>" width="600" height="100"></iframe>
    </div>
  </div>

  <div class="container-box">
    <div class="box left-box">
      <h2>PLEASE WAIT</h2>
      <div class="countdown" id="countdown"><?php echo $countdown_time; ?></div>
      <p class="redirect-text">
        You are being redirected securely.<br>
        Please wait while we connect you.<br>
        Redirect will start automatically.<br>
        If it does not start, <a href="<?php echo $redirect_url; ?>">click here</a>.
      </p>
      <img src="<?php echo $loading_gif; ?>" alt="Loading...">
    </div>

    <div class="box right-box">
      <h3>UNLIMITED ACCESS</h3>
      <div class="price">$0</div>
      <ul>
        <li>ONLINE ACTIVATION</li>
        <li>HD STREAMING – 1080P / 4K</li>
        <li>NO ADS</li>
        <li>ALL PLATFORMS</li>
        <li>QUICK & EASY SIGNUP</li>
      </ul>
    </div>
  </div>

  <!-- Banner bawah -->
  <div class="banner-wrapper">
    <button class="toggle-btn" onclick="toggleBanner('bannerBawah', this)">Hide Ads</button>
    <div class="banner-container" id="bannerBawah">
      <iframe src="<?php echo $banner_bottom; ?>" width="300" height="250"></iframe>
    </div>
  </div>

  <script>
    // Countdown sinkron dengan config.php
    let timeLeft = <?php echo $countdown_time; ?>;
    const countdownEl = document.getElementById('countdown');

    const timer = setInterval(() => {
      timeLeft--;
      countdownEl.textContent = timeLeft;
      if (timeLeft <= 0) clearInterval(timer);
    }, 1000);

    // Toggle banner hide/show
    function toggleBanner(bannerId, btn) {
      const banner = document.getElementById(bannerId);
      banner.classList.toggle('hidden');
      btn.textContent = banner.classList.contains('hidden') ? 'Show Ads' : 'Hide Ads';
    }
  </script>

<div><!-- Histats Tracking -->
<script type="text/javascript">
var _Hasync= _Hasync|| [];
_Hasync.push(['Histats.start', '1,3639954,4,0,0,0,00000000']);
_Hasync.push(['Histats.fasi', '1']);
_Hasync.push(['Histats.track_hits', '']);
(function() {
var hs = document.createElement('script'); hs.type = 'text/javascript'; hs.async = true;
hs.src = ('//s10.histats.com/js15_as.js');
(document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(hs);
})();
</script>
<noscript><a href="/" target="_blank"><img src="//sstatic1.histats.com/0.gif?3639954&101" alt="" border="0"></a></noscript>
</div>
</body>
</html>
